
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_IO_FILE_H_
#define _NEUROSIS_ENGINE_IO_FILE_H_

/***************************************************************************/

//------------------------------------------------
#define LOG_BLACK									0
#define LOG_RED										1
#define LOG_GREEN									2
#define LOG_BLUE									3
//------------------------------------------------

/***************************************************************************/

class CNeurosisIO {
	public:
		CNeurosisIO();
		//! Constructor/Deconstructor
		~CNeurosisIO();

		//! Create dummy file
		static bool			Create_Dummy_File(const char *filename, int byteSize);
		//! Append string to log
		static void			Log_Append(FILE *pFile, int textColor, bool showDateTime, const char *data, ...);
		//! Logs the previous GetLastError() message to log
		static void			Log_Error(FILE *pFile, int textColor, const char *textInfo);
		//! Initialize log
		static FILE*		Log_Initialize(const char *filename, bool newFile);
		//! Delete registry key
		static void			Registry_Delete(HKEY key, char *subkey, char *name);
		//! Retrieve registry key
		static CString	Registry_Retrieve(HKEY key, char *subkey, char *name);
		//! Store registry key
		static void			Registry_Store(HKEY key, char *subkey, char *name, char *data);
		//! Retrive string from ini file
		static CString	Retrieve_Data_INI(const char *filename, const char *section, const char *key, const char *defaultValue, ...);
		//! Retrieve string from file (token is not case sensitive)
		//! Token-Value separator can be either "\t" or " = "
		static CString	Retrieve_Data_TXT(const char *filename, const char *token, const char *defaultValue);
		//! Retrieve string from url (put into retVal or into file filename if given)
		static CString	Retrieve_Data_URL(const char *urlString, const char *filename);
		//! Retrieve extension of file
		static CString	Retrieve_Extension(CString filename);
		//! Retrieve size of file
		static int			Retrieve_File_Size(const char *filename);
		//! Retrieve time file was created
		static int			Retrieve_File_Time_Create(const char *filename);
		//! Retrieve time file was modified
		static int			Retrieve_File_Time_Modify(const char *filename);
		//! Retrieve time folder was created
		static int			Retrieve_Folder_Time_Create(const char *foldername);
		//! Sets file position to after given string (token is not case sensitive)(returns false if token not found)
		static bool			Retrieve_String_Position(FILE *pFile, const char *token, bool resetFilePosition = false);
		//! Save string to ini file
		static void			Save_Data_INI(const char *filename, const char *section, const char *key, const char *data, ...);
};

/***************************************************************************/
#endif